/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.compat.jei;

import java.util.Arrays;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import xyz.przemyk.simpleplanes.blocks.PlaneWorkbenchBlock;
import xyz.przemyk.simpleplanes.container.PlaneWorkbenchContainer;
import xyz.przemyk.simpleplanes.recipes.PlaneWorkbenchRecipe;
import xyz.przemyk.simpleplanes.setup.SimplePlanesBlocks;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;

public class PlaneWorkbenchRecipeCategory
implements IRecipeCategory<PlaneWorkbenchRecipe> {
    public static final ResourceLocation ID = new ResourceLocation("simpleplanes", "plane_workbench");
    private final IDrawable background;
    private final IDrawable icon;

    public PlaneWorkbenchRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(new ResourceLocation("jei", "textures/gui/gui_vanilla.png"), 0, 168, 125, 18);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)SimplePlanesItems.PLANE_WORKBENCH.get()));
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends PlaneWorkbenchRecipe> getRecipeClass() {
        return PlaneWorkbenchRecipe.class;
    }

    public String getTitle() {
        return this.getTitleAsTextComponent().getString();
    }

    public ITextComponent getTitleAsTextComponent() {
        return ((PlaneWorkbenchBlock)SimplePlanesBlocks.PLANE_WORKBENCH_BLOCK.get()).func_235333_g_();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(PlaneWorkbenchRecipe recipe, IIngredients ingredients) {
        Stream<ItemStack> materialStackStream = BlockTags.func_199896_a().func_241834_b(PlaneWorkbenchContainer.PLANE_MATERIALS).func_230236_b_().stream().map(block -> new ItemStack((IItemProvider)block.func_199767_j(), recipe.materialAmount));
        ingredients.setInputIngredients(Arrays.asList(Ingredient.func_234819_a_(Arrays.stream(recipe.ingredient.func_193365_a()).map(itemStack -> new ItemStack((IItemProvider)itemStack.func_77973_b(), recipe.ingredientAmount))), Ingredient.func_234819_a_(materialStackStream)));
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.result);
    }

    public void setRecipe(IRecipeLayout recipeLayout, PlaneWorkbenchRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 0, 0);
        guiItemStacks.init(1, true, 49, 0);
        guiItemStacks.init(2, false, 107, 0);
        guiItemStacks.set(ingredients);
    }
}

